-- Microsoft SQL Server DDL
-- create constraints and indices script

-- start
use pcmag
go

----------
-- create data table indices

select "starting full indexing run", getdate()
go

-- uniques (4 indices, 1 of which is clustered)
select "creating uniques indices", getdate()
go

alter table uniques add constraint uniques_key_PK_IDX primary key clustered (u_key)
go
alter table uniques add constraint uniques_signed_CK_IDX unique (u_signed)
go
alter table uniques add constraint uniques_code_CK_IDX unique (u_code)
go
create index uniques_name_IDX on uniques (u_name)
go

select "finished creating uniques indices", getdate()
go

-- hundred (6 indices, 1 of which is clustered)
select "creating hundred indices", getdate()
go

alter table hundred add constraint hundred_key_PK_IDX primary key clustered (h_key)
go
create index hundred_int_IDX on hundred (h_int)
go
create index hundred_signed_IDX on hundred (h_signed)
go
create index hundred_date_IDX on hundred (h_date)
go
alter table hundred add constraint hundred_code_CK_IDX unique (h_code)
go
create index hundred_name_IDX on hundred (h_name)
go

select "finished creating hundred indices", getdate()
go

-- tenpct (9 indices, 1 of which is clustered)
select "creating tenpct indices", getdate()
go

alter table tenpct add constraint tenpct_key_code_PK_IDX primary key clustered (t_key, t_code)
go
create index tenpct_int_IDX on tenpct (t_int)
go
create index tenpct_signed_IDX on tenpct (t_signed)
go
create index tenpct_float_IDX on tenpct (t_float)
go
create index tenpct_double_IDX on tenpct (t_double)
go
create index tenpct_decim_IDX on tenpct (t_decim)
go
create index tenpct_date_IDX on tenpct (t_date)
go
alter table tenpct add constraint tenpct_code_CK_IDX unique (t_code)
go
create index tenpct_name_IDX on tenpct (t_name)
go

select "finished creating tenpct indices", getdate()
go

-- updates (6 indices, 1 of which is clustered, 1 foreign key)
select "creating updates indices", getdate()
go

alter table updates add constraint updates_key_PK_IDX primary key clustered (p_key)
go
create index updates_int_IDX on updates (p_int)
go
alter table updates add constraint updates_int_FK foreign key (p_int) references hundred (h_key)
go
create index updates_signed_IDX on updates (p_signed)
go
create index updates_decim_IDX on updates (p_decim)
go
create index updates_date_IDX on updates (p_date)
go
alter table updates add constraint updates_code_CK_IDX unique (p_code)
go

select "finished creating updates indices", getdate()
go

-------------------------

-- tenthou (5 indices, 1 of which is clustered)
select "creating tenthou indices", getdate()
go

alter table tenthou add constraint tenthou_key_code_PK_IDX primary key clustered (t_key, t_code)
go
create index tenthou_signed_IDX on tenthou (t_signed)
go
create index tenthou_decim_IDX on tenthou (t_decim)
go
alter table tenthou add constraint tenthou_code_CK_IDX unique (t_code)
go
create index tenthou_name_IDX on tenthou (t_name)
go

select "finished creating tenthou indices", getdate()
go

-- hunthou (1 index)
select "creating hunthou indices", getdate()
go

create index hunthou_signed_IDX on hunthou (h_signed)
go

select "finished creating hunthou indices", getdate()
go

-- twomill (3 indices, 1 of which is clustered)
select "creating twomill indices", getdate()
go

alter table twomill add constraint twomill_key_PK_IDX primary key clustered (p_key)
go
create index twomill_date_IDX on twomill (p_date)
go
alter table twomill add constraint twomill_code_CK_IDX unique (p_code)
go

select "creating twomill indices", getdate()
go

-- threemill (2 indices, 1 of which is clustered)
select "creating threemill indices", getdate()
go

alter table threemill add constraint threemill_key_PK_IDX primary key clustered (t_key)
go
create index threemill_signed_IDX on threemill (t_signed)
go

select "finished creating threemill indices", getdate()
go

-- fourmill (2 indices, 1 of which is clustered)
select "creating fourmill indices", getdate()
go

alter table fourmill add constraint fourmill_key_PK_IDX primary key clustered (t_key)
go
create index fourmill_name_IDX on fourmill (t_name)
go

select "finished creating fourmill indices", getdate()
go

-- fivemill (2 indices, 1 of which is clustered)
select "creating fivemill indices", getdate()
go

alter table fivemill add constraint fivemill_key_PK_IDX primary key clustered (h_key)
go
alter table fivemill add constraint fivemill_code_CK_IDX unique (h_code)
go

select "finished creating fivemill indices", getdate()
go

-- fourram (1 index, 1 of which is clustered)
select "creating fourram indices", getdate()
go

alter table fourram add constraint fourram_key_PK_IDX primary key clustered (p_key)
go

select "finished creating fourram indices", getdate()
go

----------
-- create housekeeping table indices

-- update_int_history (2 indices, 1 of which is clustered)
select "creating update_int_history indices", getdate()
go

alter table update_int_history add constraint update_int_history_key_int_PK_IDX primary key clustered (p_key, p_int)
go
create index update_int_history_int_IDX on update_int_history (p_int)
go

select "finished creating update_int_history indices", getdate()
go

-- update_signed_history (2 indices, 1 of which is clustered)
select "creating update_signed_history indices", getdate()
go

alter table update_signed_history add constraint update_signed_history_key_signed_PK_IDX primary key clustered (p_key, p_signed)
go
create index update_signed_history_signed_IDX on update_signed_history (p_signed)
go

select "finished creating update_signed_history indices", getdate()
go

-- del_history (1 index, 1 of which is clustered)
select "creating del_history indices", getdate()
go

alter table del_history add constraint del_history_key_PK_IDX primary key clustered (h_key)
go

select "finished creating del_history indices", getdate()
go

----------

-- end
select "finished full indexing run", getdate()
go
checkpoint
go
